function array_out = rangemax(array_in,varargin)
%This function streches the current image's value over the entire dynamic
%range of the specified scale.
%Syntax:    array_out = rangemax(array_in,new_lim,old_lim);
%Input:     array_in = the input image
%           new_lim = the new scale, e.g., 256 is the uint8 scale.
%           old_lim = the old scale
%Output:    array_out = the processed image streched over the entire
%           dynamic scale.

if isempty(varargin)
    new_lim = 255;          %Set default
    old_lim = double(absmax(array_in));   %Find and set the old scale max
else
    a = size(varargin);
    if a(1,2)>1
        if varargin{1,1}<varargin{1,2}
            warning(['It is not recommended to have your new scale set smaller than your old scale.  ',...
                num2str(varargin{1,1}),' is your new max, and ',num2str(varargin{1,2}),' is your old max.',...
                '  If the is not your desired configuration please check help.'])
        end
        new_lim = varargin{1,1}-1;  %Remember the actual scale is 0-255 for 256 places.
        old_lim = double(varargin{1,2});
    else
        new_lim = varargin{1,1};    
        old_lim = double(max(max(array_in)));
    end
end

array_out = zeros(size(array_in));  %Initialize array_out
array_in = double(array_in);        %Conversion to double allows for decimals

array_out = (array_in./old_lim).*new_lim;   %Matrix calculation

array_out = uint8(array_out);       %Back to uint8 for easy display purposes